% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_functions.R
\name{fst_ngrams_compare_plot}
\alias{fst_ngrams_compare_plot}
\title{Plot comparison n-grams}
\usage{
fst_ngrams_compare_plot(
  table,
  number = 10,
  ngrams = 1,
  unique_colour = "indianred",
  name = NULL,
  override_title = NULL,
  title_size = 20
)
}
\arguments{
\item{table}{The table of n-grams, output of `get_unique_ngrams()`.}

\item{number}{The number of n-grams, default is `10`.}

\item{ngrams}{The type of n-grams, default is `1`.}

\item{unique_colour}{Colour to display unique words, default is `"indianred"`.}

\item{name}{An optional "name" for the plot, default is `NULL`.}

\item{override_title}{An optional title to override the automatic one for
the plot. Default is `NULL`. If `NULL`, title of plot will be `number` "Most
Common 'Term'". 'Term' is "Words", "Bigrams", or "N-Grams" where N > 2.}

\item{title_size}{size to display plot title}
}
\value{
Plot of top n-grams with unique terms highlighted.
}
\description{
Plots frequency n-grams with unique n-grams highlighted.
}
\examples{
top_child <- fst_freq_table(fst_child)
top_dev <- fst_freq_table(fst_dev_coop)
unique_words <- fst_get_unique_ngrams_separate(top_child, top_dev)
top_child_u <- fst_join_unique(top_child, unique_words)
top_dev_u <- fst_join_unique(top_dev, unique_words)
fst_ngrams_compare_plot(top_child_u, ngrams = 1, name = "Child")
fst_ngrams_compare_plot(top_dev_u, ngrams = 1, name = "Dev", title_size = 10)
}
