% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\docType{methods}
\name{initialize,odemodel-method}
\alias{initialize,odemodel-method}
\title{Constructor method of "odemodel" class}
\usage{
\S4method{initialize}{odemodel}(
  .Object,
  name,
  model,
  observation,
  initial,
  par,
  link,
  diffnames,
  keep_sensitivity = TRUE,
  call
)
}
\arguments{
\item{.Object}{object}

\item{name}{name of the model}

\item{model}{ode model}

\item{observation}{observation model}

\item{initial}{initial values}

\item{par}{model parameters}

\item{link}{link functions for parameters (log links are used as default)}

\item{diffnames}{optional character vector specifying the names of a variable for which the consecutive difference needs to be calculated}

\item{keep_sensitivity}{(logical) maintain the Jacobian as a part of the model object?}

\item{call}{original function call}
}
\value{
An object of class ``odemodel'' as described in \code{\link{odemodel-class}}.
}
\description{
Constructor method of "odemodel" class
}
\examples{
SI_model <- odemodel(
    name = "SI",
    model = list(
        S ~ - beta*S*I/N,
        I ~ beta*S*I/N - gamma*I
    ),
    observation = list(
        susceptible ~ dnorm(mean=S, sd=sigma1),
        infected ~ dnorm(mean=I, sd=sigma2)
    ),
    initial = list(
        S ~ N * (1 - i0),
        I ~ N * i0
    ),
    par = c("beta", "gamma", "N", "i0", "sigma1", "sigma2"),
    link = c(i0="logit")
)
}
