% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_duplicate_cols.R
\name{find_duplicate_cols}
\alias{find_duplicate_cols}
\title{Find Duplicate Columns}
\usage{
find_duplicate_cols(df)
}
\arguments{
\item{df}{A data frame}
}
\value{
A message indicating which columns are duplicates of which other columns
}
\description{
This function takes a data frame as input and checks for duplicate columns.
A column is considered a duplicate of another column if all values in both columns are the same.
If any duplicate columns are found, the function prints a message indicating which columns are duplicates of which other columns.
If no duplicate columns are found, the function prints a message indicating that no duplicates were found.
}
\examples{
df <- data.frame(w = c(7, 8, 180, 7), x = c("a", "b", "c", "a"),
                 y = c(4, NA, -6, 4), z = c(7, 8, 180, 7))
find_duplicate_cols(df)
# Column 'c' is a duplicate of column 'a'
}
