% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_multiflashlight.R
\name{predict.multiflashlight}
\alias{predict.multiflashlight}
\title{Predictions for multiflashlight}
\usage{
\method{predict}{multiflashlight}(object, ...)
}
\arguments{
\item{object}{An object of class \code{multiflashlight}.}

\item{...}{Arguments used to update the multiflashlight.}
}
\value{
A named list of prediction vectors.
}
\description{
Predict method for an object of class \code{multiflashlight}. Pass additional elements to update the flashlight, typically \code{data}.
}
\examples{
fit_part <- lm(Sepal.Length ~ Petal.Length, data = iris)
fit_full <- lm(Sepal.Length ~ ., data = iris)
mod_full <- flashlight(model = fit_full, label = "full")
mod_part <- flashlight(model = fit_part, label = "part")
mods <- multiflashlight(list(mod_full, mod_part), data = iris, y = "Sepal.Length")
predict(mods, data = iris[1:5, ])
}
