#' Official population in the municipalities of Granada (Spain)
#'
#' A dataset containing official population figures resulting from the revision
#' of the Municipal Register on January 1 for the municipalities of Granada
#' (Spain). It is a pivot table that has rows before and after it.
#'
#' @format A `pivot_table` object.
#' @source \url{https://www.ine.es/dynt3/inebase/index.htm?padre=525}
"pt_ine2871"

#' Pivot table with basic and subtotal labels in the same column
#'
#' A dataset containing number of train passengers, generated with the
#' `pivottabler` package. It contains basic and subtotal labels in the same
#' column.
#'
#' @format A `pivot_table` object.
#' @source
#'   \url{https://CRAN.R-project.org/package=pivottabler}
#'
"pt_pivottabler"

#' Pivot table with with thousands indicator and decimal numbers
#'
#' Pivot table with with thousands indicator and decimal numbers.
#'
#' @format A `pivot_table` object.
#'
"pt_m4"

#' Pivot table with a column with data from two label fields
#'
#' Pivot table in compact table format: with a column with data from two label
#' fields.
#'
#' @format A `pivot_table` object.
#'
"pt_m4_compact"

#' Set of pivot tables placed horizontally on one sheet
#'
#' Set of pivot tables placed horizontally on one sheet.
#'
#' @format A `pivot_table` object.
#'
"pt_set_h"

#' Set of pivot tables on one sheet
#'
#' Example of a set of pivot tables located horizontally and vertically on one
#' sheet.
#'
#' @format A `pivot_table` object.
#'
"pt_set_h_v"

#' Set of pivot tables placed vertically on one sheet
#'
#' Set of pivot tables placed vertically on one sheet.
#'
#' @format A `pivot_table` object.
#'
"pt_set_v"

#' List of pivot tables
#'
#' List of pivot tables.
#'
#' @format List of `pivot_table` objects.
#'
"list_pt"

#' Pivot tables with a column with data from two label fields
#'
#' List of pivot tables with a column with data from two label fields (this is
#' generally known as compact table format).
#'
#' @format List of `pivot_table` objects.
#'
"list_pt_compact"

#' List of pivot tables used in the vignette
#'
#' List of pivot tables used in the vignette, an illustrative example.
#'
#' @format List of `pivot_table` objects.
#'
"list_pt_ie"
