% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{remove_agg}
\alias{remove_agg}
\alias{remove_agg.pivot_table}
\title{Remove rows and columns with aggregated data}
\usage{
remove_agg(pt)

\method{remove_agg}{pivot_table}(pt)
}
\arguments{
\item{pt}{A \code{pivot_table} object.}
}
\value{
A \code{pivot_table} object.
}
\description{
Aggregated data is recognized because the label of the row or column closest
to the array of values is empty.
}
\details{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data.

Removes pivot table rows and columns that contain aggregated data. It only
checks the value in the row or column closest to the array of values.

To correctly carry out this operation, the number of rows and columns that
contain labels must be defined, and the table must only contain the pivot
table rows and columns.
}
\examples{

pt <-
  pt_ex |>
  remove_top(1) |>
  define_labels(n_col = 2, n_row = 2) |>
  remove_agg()

}
\seealso{
\code{\link{pivot_table}}

Other pivot table transformation functions: 
\code{\link{extract_labels}()},
\code{\link{fill_labels}()},
\code{\link{fill_values}()},
\code{\link{remove_bottom}()},
\code{\link{remove_cols}()},
\code{\link{remove_empty}()},
\code{\link{remove_k}()},
\code{\link{remove_left}()},
\code{\link{remove_right}()},
\code{\link{remove_rows}()},
\code{\link{remove_top}()},
\code{\link{replace_dec}()},
\code{\link{unpivot}()}
}
\concept{pivot table transformation functions}
