% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_hasValue}
\alias{fxml_hasValue}
\title{Value of an XML element}
\usage{
fxml_hasValue(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
\code{TRUE} if the XML element has a value (not being equal to \code{NA}), \code{FALSE} otherwise.
}
\description{
Determines if an XML element carries a value.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Check if element with ID 4 (xml.dataframe$elemid. ==  4) carries a value
fxml_hasValue(xml.dataframe, 4)

}
\seealso{
\code{\link{fxml_getValue}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
