% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_hasChildren}
\alias{fxml_hasChildren}
\title{Children of an XML element}
\usage{
fxml_hasChildren(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
\code{TRUE}, if the the XML element with ID \code{elemid} has at least one child, \code{FALSE} otherwise.
}
\description{
Determines if an XML element has any children.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Check, if the XML element with ID 4 (xml.dataframe$elemid. ==  4) has any
# children (sub-elements)
fxml_hasChildren(xml.dataframe, 4)
}
\seealso{
\code{\link{fxml_numChildren}}, \code{\link{fxml_getChildren}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
