% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.flexsurvreg.R
\name{coxsnell_flexsurvreg}
\alias{coxsnell_flexsurvreg}
\title{Cox-Snell residuals from a parametric survival model}
\usage{
coxsnell_flexsurvreg(x)
}
\arguments{
\item{x}{Object returned by \code{\link{flexsurvreg}} or \code{\link{flexsurvspline}} representing a fitted survival model}
}
\value{
A data frame with a column called \code{est} giving the Cox-Snell residual, defined as the fitted cumulative hazard at each data point.
 fitted cumulative hazard at the given observed data point, and other columns indicating the observation time,
 observed event status, and covariate values defining the data at this point.   

The cumulative hazards \code{est} should form a censored sample from an Exponential(1).  
Therefore to check the fit of the model, plot a nonparametric estimate of the cumulative
hazard curve against a diagonal line through the origin, which is the theoretical cumulative
hazard trajectory of the Exponential(1).
}
\description{
Cox-Snell residuals from a parametric survival model
}
\examples{

  fitg <- flexsurvreg(formula = Surv(futime, fustat) ~ age, data = ovarian, dist = "gengamma")
  cs <- coxsnell_flexsurvreg(fitg)
  
  ## Model appears to fit well, with some small sample noise 
  surv <- survfit(Surv(cs$est, ovarian$fustat) ~ 1)
  plot(surv, fun="cumhaz")
  abline(0, 1, col="red")
  
}
