% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{colformat_int}
\alias{colformat_int}
\alias{colformat_int.flextable}
\title{format integer cells}
\usage{
colformat_int(x, ...)

\method{colformat_int}{flextable}(
  x,
  j = NULL,
  col_keys = NULL,
  big.mark = ",",
  na_str = "",
  prefix = "",
  suffix = "",
  ...
)
}
\arguments{
\item{x}{a flextable object}

\item{...}{additional arguments, i can be used to specify a
row selector.}

\item{j}{columns selection.}

\item{col_keys}{names of the colkeys. Will be deprectated in favor of j in the next
version.}

\item{big.mark}{see \code{\link[base]{formatC}}}

\item{na_str}{string to be used for NA values}

\item{prefix}{string to be used as prefix or suffix}

\item{suffix}{string to be used as prefix or suffix}
}
\description{
Format integer cells in a flextable.
}
\section{Illustrations}{


\if{html}{\figure{fig_colformat_int_1.png}{options: width=100\%}}
}

\examples{
ft <- flextable(head(mtcars))
j <- c("vs", "am", "gear", "carb")
ft <- colformat_int(x = ft, j = j, prefix = "# ")
ft
}
\seealso{
Other cells formatters: 
\code{\link{colformat_char}()},
\code{\link{colformat_lgl}()},
\code{\link{colformat_num}()},
\code{\link{compose}()}
}
\concept{cells formatters}
