% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{fontsize}
\alias{fontsize}
\title{Set font size}
\usage{
fontsize(x, i = NULL, j = NULL, size = 11, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{size}{integer value (points)}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
change font size of selected rows and columns of a flextable.
}
\section{Illustrations}{


\if{html}{\figure{fig_fontsize_1.png}{options: width=50\%}}
}

\examples{
ft <- flextable(head(iris))
ft <- fontsize(ft, size = 14, part = "header")
ft <- fontsize(ft, size = 14, j = 2)
ft <- fontsize(ft, size = 7, j = 3)
ft
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{font}()},
\code{\link{italic}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
