% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borders.R
\name{border}
\alias{border}
\title{Set cell borders}
\usage{
border(
  x,
  i = NULL,
  j = NULL,
  border = NULL,
  border.top = NULL,
  border.bottom = NULL,
  border.left = NULL,
  border.right = NULL,
  part = "body"
)
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{border}{border (shortcut for top, bottom, left and right)}

\item{border.top}{border top}

\item{border.bottom}{border bottom}

\item{border.left}{border left}

\item{border.right}{border right}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
change borders of selected rows and columns of a flextable.
}
\note{
this function requires careful
settings to avoid overlapping borders.
}
\examples{
library(officer)
ftab <- flextable(head(mtcars))
ftab <- border(ftab, border.top = fp_border(color = "orange") )
ftab
}
\seealso{
Other borders management: 
\code{\link{border_inner_h}()},
\code{\link{border_inner_v}()},
\code{\link{border_inner}()},
\code{\link{border_outer}()},
\code{\link{border_remove}()},
\code{\link{hline_bottom}()},
\code{\link{hline_top}()},
\code{\link{hline}()},
\code{\link{vline_left}()},
\code{\link{vline_right}()},
\code{\link{vline}()}
}
\concept{borders management}
