% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_with_flextable.R
\name{ph_with.flextable}
\alias{ph_with.flextable}
\title{add a flextable into a PowerPoint slide}
\usage{
\method{ph_with}{flextable}(x, value, ...)
}
\arguments{
\item{x}{a pptx device}

\item{value}{flextable object}

\item{...}{Arguments to be passed to methods, argument
\code{location} is mandatory.}
}
\description{
Add a flextable in a PowerPoint document object produced
by \code{\link[officer]{read_pptx}}.
}
\examples{
library(officer)

ft = flextable(head(iris))

doc <- read_pptx()
doc <- add_slide(doc, "Title and Content", "Office Theme")
doc <- ph_with(doc, ft, location = ph_location_left())

fileout <- tempfile(fileext = ".pptx")
print(doc, target = fileout)
}
