% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matmult.r
\docType{methods}
\name{matmult}
\alias{matmult}
\alias{\%*\%,float32,float32-method}
\alias{\%*\%,float32,matrix-method}
\alias{\%*\%,matrix,float32-method}
\title{matmult}
\usage{
\S4method{\%*\%}{float32,float32}(x, y)

\S4method{\%*\%}{float32,matrix}(x, y)

\S4method{\%*\%}{matrix,float32}(x, y)
}
\arguments{
\item{x, y}{Numeric/float matrices.}
}
\value{
A matrix of the same type as the highest precision input.
}
\description{
Matrix multiplication for numeric/float matrices.
}
\details{
If a numeric matrix is multiplied against a float matrix, then if the
"numeric" matrix is integers, the integers are promoted to floats. Otherwise,
the float matrix is promoted to doubles.
}
\examples{
library(float)

s1 = flrunif(5, 5)
s2 = flrunif(5, 2)
x = matrix(1:25, 5)

s1 \%*\% s2 # float

storage.mode(x) # integer
x \%*\% s2 # float

storage.mode(x) = "double"
x \%*\% s2 # double

}
