% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_species.R
\name{subset_species}
\alias{subset_species}
\title{Extract a subset of species from Brazilian Flora 2020 database}
\usage{
subset_species(data, species,
                      include_subspecies = FALSE,
                      include_variety = FALSE,
                      Kingdom = "Plantae")
}
\arguments{
\item{data}{(data.frame) the data.frame imported with the
\code{\link{load_florabr}} function.}

\item{species}{(character) names of the species to be extracted from
Brazilian Flora database.}

\item{include_subspecies}{(logical) include subspecies?
Default = FALSE}

\item{include_variety}{(logical) include varieties of the species?
Default = FALSE}

\item{Kingdom}{(character) The Kingdom for filtering the dataset. It can be
"Plantae" or "Fungi". Default = "Plantae". To include both,
use c("Plantae", "Fungi")}
}
\value{
A data.frame with the selected species.
}
\description{
Returns a data.frame with a subset of species from Brazilian Flora 2020
database
}
\examples{
data("bf_data") #Load Brazilian Flora data
#Species to extract from database
spp <- c("Araucaria angustifolia", "Adesmia paranensis")
spp_bf <- subset_species(data = bf_data, species = spp,
                      include_subspecies = FALSE,
                      include_variety = FALSE)
spp_bf
}
\references{
Brazilian Flora 2020. Jardim Botânico do Rio de Janeiro. Available at:
http://floradobrasil.jbrj.gov.br/
}
