% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ffi_fit_models}
\alias{ffi_fit_models}
\title{Fit various models to gas concentration data}
\usage{
ffi_fit_models(time, conc, area, volume)
}
\arguments{
\item{time}{Relative time of observation (typically seconds), numeric}

\item{conc}{Greenhouse gas concentration (typically ppm or ppb), numeric}

\item{area}{Area covered by the measurement chamber (typically cm2), numeric}

\item{volume}{Volume of the system
(chamber + tubing + analyzer, typically cm3), numeric}
}
\value{
A wide-form \code{\link{data.frame}} with fit statistics for linear
("lin", \code{\link{lm}}), robust linear ("rob", \code{\link[MASS]{rlm}}),
polynomial ("poly"), and H&M1981 ("HM81", \code{\link{ffi_hm1981}}) models.
The latter is based on an exponential model drawn from one-dimensional
diffusion theory; see Hutchinson and Mosier (1981) and Nakano et al. (2004).

For each model type, the following columns are returned:
\itemize{
\item Model statistics \code{AIC}, \code{r.squared}, \code{RMSE},
and \code{p.value};
\item Flux (slope) statistics \code{flux.estimate} and \code{flux.std.error};
\item Intercept statistics \code{int.estimate} and \code{int.std.error};
\item For the robust linear regression model only,
a logical value \code{converged}.
}
}
\description{
Fit various models to gas concentration data
}
\details{
If a linear model cannot be fit, NULL is returned. If the robust
linear and/or polynomial models cannot be fit, then \code{NA} is returned
for their particular statistics. The HM1981 approach is only valid for
saturating (exponential) data and \code{NA} is returned otherwise.
}
\note{
Normally this is not called directly by users,
but instead via \code{\link{ffi_compute_fluxes}}.
}
\examples{
# Toy data - linear
ffi_fit_models(cars$speed, cars$dist)

# Toy data - nonlinear
ffi_fit_models(Puromycin$conc, Puromycin$rate)

# Real data
f <- system.file("extdata/TG10-01087.data", package = "fluxfinder")
dat <- ffi_read_LI7810(f)[1:75,] # isolate first observation
dat$SECONDS <- dat$SECONDS - min(dat$SECONDS) # normalize time to start at 0
plot(dat$SECONDS, dat$CO2)
ffi_fit_models(dat$SECONDS, dat$CO2)
}
\references{
Nakano, T., Sawamoto, T., Morishita, T., Inoue, G., and Hatano, R.:
A comparison of regression methods for estimating soil–atmosphere diffusion
gas fluxes by a closed-chamber technique, Soil Biol. Biochem.,
36, 107–113, 2004. \doi{10.1016/j.soilbio.2003.07.005}

Hutchinson, G. L. and Mosier, A. R.: Improved soil cover method for field
measurement of nitrous oxide fluxes, Soil Sci. Soc. Am. J., 45, 311-316,
1981. \doi{10.2136/sssaj1981.03615995004500020017x}
}
