% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/milk.R
\docType{data}
\name{milk}
\alias{milk}
\title{Monthly milk production per cow}
\format{Time series data}
\source{
Makridakis, Wheelwright and Hyndman (1998) \emph{Forecasting:
methods and applications}, John Wiley & Sons: New York. Chapter 2.
}
\usage{
milk
}
\description{
Average monthly milk production per cow over 14 years (January 1962 - December 1975).
}
\examples{
par(mfrow=c(2,1))
plot(milk,xlab="Year",ylab="pounds",
    main="Monthly milk production per cow")
milk.adj <- milk/monthdays(milk)*365.25/12
plot(milk.adj,xlab="Year",ylab="pounds",
    main="Adjusted monthly milk production per cow")
}
\references{
Cryer (1986) \emph{Time series analysis}, Duxbury Press:
Belmont.
}
\keyword{datasets}
