% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluator.R
\name{fm_evaluator_helpers}
\alias{fm_evaluator_helpers}
\alias{fm_evaluator_mesh_2d}
\alias{fm_evaluator_mesh_1d}
\title{Internal helper functions for mesh field evaluation}
\usage{
fm_evaluator_mesh_2d(
  mesh,
  loc = NULL,
  weights = NULL,
  derivatives = NULL,
  crs = NULL,
  ...
)

fm_evaluator_mesh_1d(
  mesh,
  loc,
  weights = NULL,
  derivatives = NULL,
  method = deprecated(),
  ...
)
}
\arguments{
\item{mesh}{An \code{inla.mesh} or \code{inla.mesh.1d} object.}

\item{loc}{Projection locations.  Can be a matrix, \code{SpatialPoints},
\code{SpatialPointsDataFrame}, \code{sf}, \code{sfc}, or \code{sfg} object.}

\item{weights}{Optional weight vector, one weight for each location}

\item{derivatives}{logical; If true, also return matrices \code{dA} and \code{d2A}
for \code{fm_mesh_1d} objects, and \code{dx}, \code{dy}, \code{dz} for \code{fm_mesh_2d}.}

\item{crs}{An optional CRS or inla.CRS object associated with \code{loc}
and/or \code{lattice}.}

\item{...}{Additional arguments passed on to methods.}

\item{method}{character; either "default", "nearest", "linear", or
"quadratic". With \code{NULL} or "default", uses the object definition of the
function space. Otherwise overrides the object definition.}
}
\value{
A list of evaluator information objects, at least a matrix \code{A} and
logical vector \code{ok}.
}
\description{
Methods called internally by \code{\link[=fm_evaluator]{fm_evaluator()}} methods.
}
\examples{
str(fm_evaluator_mesh_2d(fmexample$mesh, loc = fmexample$loc))

}
\keyword{internal}
