% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fm.R
\name{fm_as_fm}
\alias{fm_as_fm}
\alias{fm_as_fm.NULL}
\alias{fm_as_fm.fm_mesh_1d}
\alias{fm_as_fm.fm_mesh_2d}
\alias{fm_as_fm.fm_mesh_3d}
\alias{fm_as_fm.fm_tensor}
\alias{fm_as_fm.fm_collect}
\alias{fm_as_fm.fm_segm}
\alias{fm_as_fm.fm_lattice_Nd}
\alias{fm_as_fm.fm_lattice_2d}
\alias{fm_as_fm.fm_bbox}
\alias{fm_as_fm.crs}
\alias{fm_as_fm.CRS}
\alias{fm_as_fm.fm_crs}
\alias{fm_as_fm.inla.CRS}
\alias{fm_as_fm.inla.mesh.1d}
\alias{fm_as_fm.inla.mesh}
\alias{fm_as_fm.inla.mesh.segment}
\alias{fm_as_fm.inla.mesh.lattice}
\title{Convert objects to fmesher objects}
\usage{
fm_as_fm(x, ...)

## S3 method for class 'NULL'
fm_as_fm(x, ...)

\method{fm_as_fm}{fm_mesh_1d}(x, ...)

\method{fm_as_fm}{fm_mesh_2d}(x, ...)

\method{fm_as_fm}{fm_mesh_3d}(x, ...)

\method{fm_as_fm}{fm_tensor}(x, ...)

\method{fm_as_fm}{fm_collect}(x, ...)

\method{fm_as_fm}{fm_segm}(x, ...)

\method{fm_as_fm}{fm_lattice_Nd}(x, ...)

\method{fm_as_fm}{fm_lattice_2d}(x, ...)

\method{fm_as_fm}{fm_bbox}(x, ...)

\method{fm_as_fm}{crs}(x, ...)

\method{fm_as_fm}{CRS}(x, ...)

\method{fm_as_fm}{fm_crs}(x, ...)

\method{fm_as_fm}{inla.CRS}(x, ...)

\method{fm_as_fm}{inla.mesh.1d}(x, ...)

\method{fm_as_fm}{inla.mesh}(x, ...)

\method{fm_as_fm}{inla.mesh.segment}(x, ...)

\method{fm_as_fm}{inla.mesh.lattice}(x, ...)
}
\arguments{
\item{x}{Object to be converted}

\item{...}{Arguments forwarded to submethods}
}
\value{
An object of some \verb{fm_*} class
}
\description{
Used for conversion from general objects
(usually \code{inla.mesh} and other legacy INLA specific classes)
to \code{fmesher} classes.
}
\examples{
fm_as_fm(NULL)

}
\seealso{
Other object creation and conversion: 
\code{\link{fm_as_collect}()},
\code{\link{fm_as_lattice_2d}()},
\code{\link{fm_as_lattice_Nd}()},
\code{\link{fm_as_mesh_1d}()},
\code{\link{fm_as_mesh_2d}()},
\code{\link{fm_as_mesh_3d}()},
\code{\link{fm_as_segm}()},
\code{\link{fm_as_sfc}()},
\code{\link{fm_as_tensor}()},
\code{\link{fm_collect}()},
\code{\link{fm_lattice_2d}()},
\code{\link{fm_lattice_Nd}()},
\code{\link{fm_mesh_1d}()},
\code{\link{fm_mesh_2d}()},
\code{\link{fm_segm}()},
\code{\link{fm_simplify}()},
\code{\link{fm_tensor}()}
}
\concept{object creation and conversion}
