% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{hrf_bspline_generator}
\alias{hrf_bspline_generator}
\title{Create B-spline HRF Basis Set}
\usage{
hrf_bspline_generator(nbasis = 5, span = 24)
}
\arguments{
\item{nbasis}{Number of basis functions (default: 5)}

\item{span}{Temporal window in seconds (default: 24)}
}
\value{
An HRF object of class \code{c("BSpline_HRF", "HRF", "function")}
}
\description{
Generates an HRF object using B-spline basis functions with custom parameters.
This is the generator function that creates HRF objects with variable numbers
of basis functions, unlike the pre-defined \code{HRF_BSPLINE} which has 5 functions.
}
\examples{
# Create B-spline basis with 10 functions
custom_bs <- hrf_bspline_generator(nbasis = 10)
t <- seq(0, 24, by = 0.1)
response <- evaluate(custom_bs, t)
matplot(t, response, type = "l", main = "B-spline HRF with 10 basis functions")
}
\seealso{
\code{\link{HRF_objects}} for pre-defined HRF objects,
  \code{\link{getHRF}} for a unified interface to create HRFs
}
