% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmap.R
\name{fmap}
\alias{fmap}
\title{fmap}
\usage{
fmap(
  x,
  y = NULL,
  what = c("fitted", "predicted"),
  conf = TRUE,
  obs = FALSE,
  by.date = FALSE,
  crs = NULL,
  ext.rng = c(0.05, 0.05),
  size = 0.25,
  col = "black"
)
}
\arguments{
\item{x}{a \code{foieGras} ssm fit object with class `fG_ssm`}

\item{y}{optionally, a \code{foieGras} mpm fit object with class `fG_mpm`; default is NULL}

\item{what}{specify which location estimates to map: fitted or predicted}

\item{conf}{include confidence regions around estimated location (logigal; default = TRUE, unless y is an mpm fit object then conf is FALSE)}

\item{obs}{include Argos observations on map (logical; default = FALSE)}

\item{by.date}{when mapping single tracks, should locations be coloured by date (logical; default = FALSE)}

\item{crs}{`proj4string` for re-projecting locations, if NULL the
default projection ("+proj=merc") for the fitting the SSM will be used}

\item{ext.rng}{factors to extend the plot range in x and y dimensions
(can exceed 1)}

\item{size}{size of estimated location points; optionally a vector of length 2, with size of observed locations given by 2nd value (ignored if obs = FALSE)}

\item{col}{colour of observed locations (ignored if obs = FALSE)}
}
\description{
map foieGras fitted or predicted locations, with or without
Argos observations, optionally apply a different projection
}
