% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_foot.R
\name{mle_foot}
\alias{mle_foot}
\title{Fit football models with Maximum Likelihood}
\usage{
mle_foot(data, model, predict, ...)
}
\arguments{
\item{data}{A data frame, or a matrix containing the following mandatory items: season, home team, away team,
home goals, away goals.}

\item{model}{The type of model used to fit the data.
One among the following: \code{"double_pois"},
\code{"biv_pois"}, \code{"skellam"}, \code{"student_t"}.}

\item{predict}{The number of out-of-sample matches. If missing, the function returns
the fit for the training set only.}

\item{...}{Optional arguments for MLE fit algorithms.}
}
\value{
MLE and 95\% profile likelihood deviance confidence intervals for the
model's parameters: attack, defence, home effect and goals' correlation.
}
\description{
ML football modelling for the most famous models:
double Poisson, bivariate Poisson, Skellam and student t.
}
\details{
See documentation of \code{stan_foot} function for model details.
MLE can be obtained only for static models, with no time-dependence.
Likelihood optimization is performed via the \code{BFGS} method
of the \code{\link{optim}} function.
}
\examples{
\donttest{
if(requireNamespace("engsoccerdata")){
require(engsoccerdata)
require(tidyverse)
require(dplyr)

italy <- as_tibble(italy)
italy_2008<- italy \%>\%
   dplyr::select(Season, home, visitor, hgoal,vgoal) \%>\%
   dplyr::filter( Season=="2008")

mle_fit <- mle_foot(data  = italy_2008,
                   model = "double_pois")
}
}


}
\references{
Baio, G. and Blangiardo, M. (2010). Bayesian hierarchical model for the prediction of football
results. Journal of Applied Statistics 37(2), 253-264.

Egidi, L., Pauli, F., and Torelli, N. (2018). Combining historical data
and bookmakers' odds in modelling football scores. Statistical Modelling, 18(5-6), 436-459.

Gelman, A. (2014). Stan goes to the World Cup. From
"Statistical Modeling, Causal Inference, and Social Science" blog.

Karlis, D. and Ntzoufras, I. (2003). Analysis of sports data by using bivariate poisson models.
Journal of the Royal Statistical Society: Series D (The Statistician) 52(3), 381-393.

Karlis, D. and Ntzoufras,I. (2009).  Bayesian modelling of football outcomes: Using
the Skellam's distribution for the goal difference. IMA Journal of Management Mathematics 20(2), 133-145.

Owen, A. (2011). Dynamic Bayesian forecasting models
of football match outcomes with estimation of the
evolution variance parameter. IMA Journal of Management Mathematics, 22(2), 99-113.
}
\author{
Leonardo Egidi \email{legidi@units.it}
}
