% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuv_core.R
\name{tuv_core}
\alias{tuv_core}
\title{Calculate TUV Online}
\usage{
tuv_core(
  wStart = 280,
  wStop = 420,
  wIntervals = 140,
  inputMode = 0,
  latitude = 0,
  longitude = 0,
  date = 20150630,
  timeStamp = "12:00:00",
  zenith = 0,
  ozone = 300,
  albedo = 0.1,
  gAltitude = 0,
  mAltitude = 0,
  taucld = 0,
  zbase = 4,
  ztop = 5,
  tauaer = 0.235,
  ssaaer = 0.99,
  alpha = 1,
  time = 12,
  outputMode = 2,
  nStreams = -2,
  dirsun = 1,
  difdn = 1,
  difup = NA
)
}
\arguments{
\item{wStart}{Shortest wavelength. The default value is 280. \cr}

\item{wStop}{Longest wavelength.  The default value is 420. \cr}

\item{wIntervals}{Number of equal-sized subdivisions of the range End-Start. The default value is 140. \cr}

\item{inputMode}{The default value is 0. InputMode 0: User-specified geographic location and time/date. The code computes the appropriate solar zenith angle and Earth-Sun distance.  InputMode 1: User specifies the solar zenith angle, and the annual average Earth-Sun distance is used. To avoid inconsistencies (e.g. overhead sun at the poles), options 1 and 2 cannot be invoked at the same time.}

\item{latitude}{Latitudes: positive North of equator, negative South of equator. The default value is 0. \cr}

\item{longitude}{Longitudes: positive East of the Greenwich meridian, negative West of the Greenwich meridian. The default value is 0. \cr}

\item{date}{Date (format: (YYYYMMDD, GMT). The default value is 20150630. \cr}

\item{timeStamp}{-> Timestamp (format: hh:mm:ss, GMT). The default value is "12:00:00". \cr}

\item{zenith}{Solar zenith angle (deg). The default value is 0. \cr}

\item{ozone}{Ozone column, in Dobson Units (du), vertical, from ground (even if above sea level) to space. The US Standard Atmosphere O3 is used to specify the shape of the vertical profile but the total column is re-scaled to the value selected here by the user. The default value is 300. \cr}

\item{albedo}{Surface albedo: Assumes a Lambertian reflection (isotropic radiance) Values for snow can reach 0.90-0.99, but otherwise values at UV wavelengths are in the range 0.02-0.20 depending on the precise surface.  The default value is 0.1.}

\item{gAltitude}{Ground elevation: The elevation of the ground, in km above mean sea level.  The default value is 0. \cr}

\item{mAltitude}{Measurement altitude: The altitude in the atmosphere for which results are requested. This should not be confused with the ground elevation. For example, if you have measurements made from an airplane, flying at 6 km above the ground, and the surface is at 1.5 km, then you will want to request results for a measurement altitude of 7.5 km asl.   The default value is 0. \cr}

\item{taucld}{Cloud Optical Depth: vertical optical depth of the cloud. The default value is 0.00.  \cr}

\item{zbase}{Cloud base: base of cloud, in km (asl). The default value is 4.00. \cr}

\item{ztop}{Cloud top:  top of cloud, in km (asl). The default value is 5.00. \cr}

\item{tauaer}{Optical Depth: total extinction (absorption + scattering) at 550 nm, vertical, from ground to space. The default value is 0.235. \cr}

\item{ssaaer}{Single Scattering Albedo (S-S alb), assumed independent of wavelength. The default value is 0.990. \cr}

\item{alpha}{Alpha (Angstrom exponent), gives wavelength dependence of optical depth, by multiplying the 550 nm value by (550 nm/wavelength, nm)**alpha. The default value is 1.000. \cr}

\item{time}{Hour. The default value is 12. \cr}

\item{outputMode}{The default value is 2.  OutputMode 2: Molecular photolysis frequencies (109 photoreactions). OutputMode 3: Weighted irradiance (27 weighting functions). OutputMode 4: Spectral actinic flux. OutputMode 5: Spectral irradiance.}

\item{nStreams}{The default value is -2.   NStreams -2: Pseudo-spherical 2 streams (faster, less accurate). NStreams 4: Pseudo-spherical discrete ordinate 4 streams (slower, more accurate).}

\item{dirsun}{Direct beam, direct solar beam. The default value is 1.0. \cr}

\item{difdn}{Diffuse down, down-ward propagating scattered radiation (diffuse sky light). The default value is 1.0. \cr}

\item{difup}{Diffuse up, up-ward propagating scattered radiation (diffuse light from below). The default value is NA. \cr}
}
\value{
a dataframe. The contents of dataframe are diterminated by OutputMode. \cr 
OutputMode 2: Molecular photolysis frequencies (109 photoreactions). \cr
OutputMode 3: Weighted irradiance (27 weighting functions). \cr
OutputMode 4: Spectral actinic flux. \cr
OutputMode 5: Spectral irradiance. \cr
}
\description{
This function runs TUV online by reading the input parameters, and summarizes the results to the new dataframe. \cr
}
