% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift.R
\name{fct_shift}
\alias{fct_shift}
\title{Shift the order of levels of a factor}
\usage{
fct_shift(f, n = 1L)
}
\arguments{
\item{f}{A factor.}

\item{n}{Positive values shift to the left; negative values shift to
the right.}
}
\description{
This is useful when the levels of an ordered factor are actually cyclical,
with different conventions on the starting point.
}
\examples{
x <- factor(
  c("Mon", "Tue", "Wed"),
  levels = c("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"),
  ordered = TRUE
)
x
fct_shift(x)
fct_shift(x, 2)
fct_shift(x, -1)
}

