% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/land_cover_explorer.R
\name{fd_landcover_esri}
\alias{fd_landcover_esri}
\title{Download data from the ESRI Land Cover Explorer}
\usage{
fd_landcover_esri(utm_code, year, quiet = TRUE)
}
\arguments{
\item{utm_code}{A character string of length 1 with an UTM code (e.g. "29N")}

\item{year}{An integer or vector of integers corresponding to the base year
of the Land Cover image. The option \code{year = 'all'} downloads all
the available images}

\item{quiet}{If \code{TRUE} (the default), suppress status messages, and
the progress bar}
}
\value{
A \code{SpatRaster}
}
\description{
Download an UTM tile of the ESRI Land Cover Explorer for a specified year
}
\examples{
\donttest{
# Download Land Cover for UTM tile 29N year 2022
lc <- fd_landcover_esri("29N", year = 2020)

# Download Land Cover for UTM time 29N for all years
lc <- fd_landcover_esri("29N", year = "all")
}
}
\references{
\url{https://livingatlas.arcgis.com/en/home/}
}
