% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest-inventory.R
\name{fd_inventory_spain}
\alias{fd_inventory_spain}
\title{Spanish Forest Inventory}
\usage{
fd_inventory_spain(
  province,
  ifn = 4,
  database = "field",
  path_metadata = NULL,
  quiet = FALSE
)
}
\arguments{
\item{province}{a character string of length 1 with the name of a
Spanish province}

\item{ifn}{number of Spanish Forest Inventory (from 2 to 4)}

\item{database}{the name of the database (either 'field' or 'gis')}

\item{path_metadata}{a character string of length 1 with the path to store the
metadata of the selected database. The default \code{path_metadata = NULL}
does not download the metadata}

\item{quiet}{if \code{TRUE}, suppress any message or progress bar}
}
\value{
A \code{list} with the tables
}
\description{
Download the tables and SIG data from the Spanish Forest Inventory
}
\details{
The IFN2 doesn't have 'gis' data for Asturias, Cantabria and Navarra.

In the future a function to process the data will be added.
}
\examples{
\donttest{
# Download MFE50 for Canary Islands
canarias_ifn4_lst <- fd_inventory_spain("Canarias")

cantabria_ifn3_gis_lst <- fd_inventory_spain("cantabria", ifn = 3, database = "gis")
}
}
\references{
\url{https://www.miteco.gob.es/es/biodiversidad/temas/inventarios-nacionales/inventario-forestal-nacional.html}
}
\seealso{
\link{metadata_forestdata} for a list of possible species
}
