% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_summarise.R
\name{tree_summarise}
\alias{tree_summarise}
\title{Calculate the equivalent diameter of trees with more than one trunk}
\usage{
tree_summarise(df, dbh, tree, th = NA, vwb = NA, vwob = NA,
  plot_area = NA, total_area = NA, .groups = NA)
}
\arguments{
\item{df}{A data frame.}

\item{dbh}{Quoted name of the diameter at breast height variable.}

\item{tree}{Quoted name of the tree variable. used to differentiate the trees' sections. If this argument is missing, the defined groups in the data frame will be used. If there are no groups in the data, the function will fail.}

\item{th}{Optional argument. Quoted name of the total height variable, in meters. Default: \code{NA}.}

\item{vwb}{Optional argument. Quoted name of the volume with bark variable, in cubic meters. Default: \code{NA}.}

\item{vwob}{Optional argument. Quoted name of the volume without bark variable, in cubic meters. Default: \code{NA}.}

\item{plot_area}{Optional argument. Quoted name of the plot area variable, or a numeric vector with the plot area value. The plot area value must be in square meters.}

\item{total_area}{Optional argument. Quoted name of the total area variable, or a numeric vector with the total area value. The total area value must be in hectares. Default: \code{NA}.}

\item{.groups}{Optional argument. Quoted name(s) of grouping variables that can be added to differentiate subdivisions of the data. Default: \code{NA}.}
}
\value{
A data frame with the the equivalent diameter calculated.
}
\description{
This function uses takes the square root of the diameters squared sum,
in order to estimate the equivalent diameter of trees. Other supplied variables
are summed up, or averaged, depending on the variable.
}
\examples{

library(forestmangr)
data("exfm18")
head(exfm18)

# Calculate the equivalent diameter of trees with more than one trunk:
tree_summarise(exfm18, "DBH",tree="Tree", .groups=c("Plot", "Species") )

}
\references{
Soares, C. P. B., Paula Neto, F. and Souza, A. L. (2012) Dendrometria e Inventario Florestal. 2nd ed. Vicosa: UFV.
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
