% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_by_user.R
\name{adjust_by_user}
\alias{adjust_by_user}
\title{Adjust by user height}
\usage{
adjust_by_user(df, user_height)
}
\arguments{
\item{df}{the data frame of raw pcl data}

\item{user_height}{the height of the laser off the ground as mounted on the
user in meters}
}
\value{
a data frame adjusted by height
}
\description{
\code{adjust_by_user} adjusts data based on the user height to acccount
for the laser's distance from the ground.
}
\details{
The function \code{adjust_by_user} simply adds the height of the user to the
return distances in the data frame to estimate true height.
}
\examples{
# Adust raw data to account for user height as PCL is user-mounted and correction
# gives actual distance from ground.

pcl_adjusted <- adjust_by_user(pcl_coded, user_height = 1.05)

}
