% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tostring.R
\name{split_word_ttype}
\alias{split_word_ttype}
\alias{wrap_string_ttype}
\title{wrap string given a Truetype font}
\usage{
split_word_ttype(str, width, fontspec, min_ok_chars)

wrap_string_ttype(
  str,
  width,
  fontspec,
  collapse = NULL,
  min_ok_chars = min(floor(nchar(str)/2), 4, floor(width/2)),
  wordbreak_ok = TRUE
)
}
\arguments{
\item{str}{(\code{string}, \code{character}, or \code{list})\cr string to be wrapped. If it is a \code{vector} or
a \code{list}, it will be looped as a \code{list} and returned with \code{unlist(use.names = FALSE)}.}

\item{width}{(\code{numeric(1)})\cr width, in characters, that the text should be wrapped to.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[=font_spec]{font_spec()}}.}

\item{min_ok_chars}{(\code{numeric(1)})\cr number of minimum characters that remain
on either side when a word is split.}

\item{collapse}{(\code{string} or \code{NULL})\cr collapse character used to separate segments of words that
have been split and should be pasted together. This is usually done internally with \code{"\\n"} to update
the wrapping along with other internal values.}

\item{wordbreak_ok}{(\code{logical(1)})\cr should breaking within a word be allowed? If, \code{FALSE},
attempts to wrap a string to a width narrower than its widest word will result
in an error.}
}
\value{
\code{str}, broken up into a word-wrapped vector
}
\description{
wrap string given a Truetype font
}
