% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formods.R
\name{unfactor}
\alias{unfactor}
\title{Remove Factor From Object}
\usage{
unfactor(fctobj)
}
\arguments{
\item{fctobj}{Factorized object}
}
\value{
Object with factors removed
}
\description{
Takes an object that is a factor and returns an unfactored
vector with the same type by the value removed
}
\examples{

df = data.frame(
   text  = c("a", "b", "c"),
   float = c( 1 ,  2 ,  3 ))

df$float = as.factor(df$float)
# This is a factor
df$float
# This is not a factor
unfactor(df$float)
}
