% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markerSim.R
\name{markerSim}
\alias{markerSim}
\title{Marker simulation}
\usage{
markerSim(
  x,
  N = 1,
  ids = NULL,
  alleles = NULL,
  afreq = NULL,
  mutmod = NULL,
  rate = NULL,
  partialmarker = NULL,
  loopBreakers = NULL,
  eliminate = 0,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{N}{A positive integer: the number of (independent) markers to be
simulated.}

\item{ids}{A vector containing ID labels of those pedigree members whose
genotypes should be simulated. By default, all individuals are included.}

\item{alleles}{(Only if \code{partialmarker} is NULL.) A vector with allele
labels. If NULL, the following are tried in order:
\itemize{
\item \code{names(afreq)}
\item `seq_along(afreq)'
\item \code{1:2} (Fallback if both \code{alleles} and \code{afreq} are NULL.)
}}

\item{afreq}{(Only if \code{partialmarker} is NULL.) A numeric vector with allele
frequencies, possibly named with allele labels.}

\item{mutmod, rate}{Arguments specifying a mutation model, passed on to
\code{\link[pedtools:marker]{pedtools::marker()}} (see there for explanations).}

\item{partialmarker}{Either NULL (resulting in unconditional simulation), a
marker object (on which the simulation should be conditioned) or the name
(or index) of a marker attached to \code{x}.}

\item{loopBreakers}{A numeric containing IDs of individuals to be used as
loop breakers. Relevant only if the pedigree has loops, and only if
\code{partialmarker} is non-NULL. See \code{\link[pedtools:inbreedingLoops]{pedtools::breakLoops()}}.}

\item{eliminate}{A non-negative integer, indicating the number of iterations
in the internal genotype-compatibility algorithm. Positive values can save
time if \code{partialmarker} is non-NULL and the number of alleles is large.}

\item{seed}{An integer seed for the random number generator (optional).}

\item{verbose}{A logical.}
}
\value{
A \code{ped} object equal to \code{x} except its \code{MARKERS} entry, which
consists of the \code{N} simulated markers.
}
\description{
Simulates marker genotypes conditional on the pedigree structure and known
genotypes. Note: This function simulates independent realisations at a single
locus. Equivalently, it can be thought of as independent simulations of
identical, unlinked markers. For simulations of a \emph{set} of markers, see
\code{\link[=profileSim]{profileSim()}}.
}
\details{
This implements (with various time savers) the algorithm used in SLINK of the
LINKAGE/FASTLINK suite. If \code{partialmarker} is NULL, genotypes are simulated
by simple gene dropping, using \code{\link[=simpleSim]{simpleSim()}}.
}
\examples{
x = nuclearPed(2)

# Unconditional simulation
markerSim(x, N = 2, alleles = 1:3)

# Conditional on one child being homozygous 1/1
x = setMarkers(x, marker(x, '3' = 1, alleles = 1:3))
markerSim(x, N = 2, partialmarker = 1)
markerSim(x, N = 1, ids = 4, partialmarker = 1, verbose = FALSE)

}
\references{
G. M. Lathrop, J.-M. Lalouel, C. Julier, and J. Ott, \emph{Strategies
for Multilocus Analysis in Humans}, PNAS 81(1984), pp. 3443-3446.
}
\seealso{
\code{\link[=profileSim]{profileSim()}}, \code{\link[=simpleSim]{simpleSim()}}
}
\author{
Magnus Dehli Vigeland
}
