% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mfdfa}
\alias{mfdfa}
\title{Multifractal Detrended Fluctuation Analysis}
\usage{
mfdfa(x, q, order, scale_min, scale_max, scale_ratio)
}
\arguments{
\item{x}{A real valued vector (i.e., time series data) to be analyzed.}

\item{q}{A real valued vector indicating the statistical moments (q) to use 
in the analysis.}

\item{order}{is an integer indicating the polynomial order used for 
detrending the local windows (e.g, 1 = linear, 2 = quadratic, etc.). There 
is not pre-determined limit on the order of the polynomial order but the 
user should avoid using a large polynomial on small windows. This can result
in overfitting and non-meaningful estimates.}

\item{scale_min}{An integer indicating the minimum window size, specified in the number of data points (i.e., observations) to be included in the smallest window.}

\item{scale_max}{An integer indicating the maximum window size, specified in the number of data points (i.e., observations) to be included in the largest window. indicating largest scale to resolve}

\item{scale_ratio}{A scaling factor by which to create successive window sizes from `scale_min` to `scale_max`. 
This allows one to to maintain even spacing in logarithms while increasing
scale resolution.}
}
\value{
The output of the algorithm is a list that includes:
\itemize{ 
 \item \code{log2scale} The log2 scales used for the analysis
 \item \code{log2Fq} The log2 of the fluctuation functions for each scale and q 
 \item \code{Hq} The q-order Hurst exponent (generalized Hurst exponent)
 \item \code{Tau} The q-order mass exponent
 \item \code{q} The q-order statistical moments
 \item \code{h} The q-order singularity exponent
 \item \code{Dh} The dimension of the q-order singularity exponent
}
}
\description{
Fast function for computing multifractal detrended fluctuation analysis (MF-DFA), a widely used method for estimating the family of long-range temporal correlations or scaling exponents in time series data. 
MF-DFA is also a form of multifractal analysis that indicates the degree of interaction across temporal scales.
}
\details{
Details of the algorithm are specified in detail in Kantelhardt et al. (2001; 2002) and visualized nicely in Kelty-Stephen et al. (2016).

Selecting the range of values for q is important. Note that MF-DFA estimates for q = 2 are equivalent to DFA. Larger values of q (q > 2) emphasize larger residuals and smaller values of q
(q < 2) emphasis smaller residuals (Kelty-Stephen et al., 2016). For most biomedical signals such as physiological and kinematic, a q range of -5 to 5 is common (Ihlen, 2010). However, in some cases, 
such as when time series are short (< 3000), it can be appropriate to limit the range of q to positive only. Kelty-Stephen et al. (2016) recommend a 
positive q range of 0.5 to 10 with an increment of 0.5. 

While it is common to use only linear detrending with DFA and MF-DFA, it is important to inspect the trends in the data to determine
if it would be more appropriate to use a higher order polynomial for detrending, and/or compare the DFA and MF-DFA output for different polynomial orders (see Ihlen, 2012; Kantelhardt et al., 2001).

General recommendations for choosing the min and max scale are a scale_min = 10 and scale_max = (N/4), where N is the number of observations.
See Eke et al. (2002), Gulich and Zunino (2014), Ihlen (2012), and  for additional considerations and information on choosing the correct parameters.
}
\examples{



noise <- rnorm(5000)

mf.dfa.white.out <- mfdfa(
    x = noise, q = c(-5:5), 
    order = 1, 
    scale_min = 16, 
    scale_max = length(noise)/4, 
    scale_ratio = 2) 
 
pink.noise <- fgn_sim(n = 5000, H = 0.9)

mf.dfa.pink.out <- mfdfa(
    x = pink.noise, 
    q = c(-5:5), 
    order = 1, 
    scale_min = 16, 
    scale_max = length(pink.noise)/4, 
    scale_ratio = 2)



}
\references{
Ihlen, E. A. F. (2012). Introduction to Multifractal Detrended Fluctuation Analysis in Matlab. Frontiers in Physiology, 3. https://doi.org/10.3389/fphys.2012.00141

Kantelhardt, J. W., Koscielny-Bunde, E., Rego, H. H., Havlin, S., & Bunde, A. (2001). Detecting long-range correlations with detrended fluctuation analysis. Physica A: Statistical Mechanics and its Applications, 295(3-4), 441-454.

Kantelhardt, J. W., Zschiegner, S. A., Koscielny-Bunde, E., Havlin, S., Bunde, A., & Stanley, H. E. (2002). Multifractal detrended fluctuation analysis of nonstationary time series. Physica A: Statistical Mechanics and its Applications, 316(1-4), 87-114.

Kelty-Stephen, D. G., Palatinus, K., Saltzman, E., & Dixon, J. A. (2013). A Tutorial on Multifractality, Cascades, and Interactivity for Empirical Time Series in Ecological Science. Ecological Psychology, 25(1), 1-62. https://doi.org/10.1080/10407413.2013.753804

Kelty-Stephen, D. G., Stirling, L. A., & Lipsitz, L. A. (2016). Multifractal temporal correlations in circle-tracing behaviors are associated with the executive function of rule-switching assessed by the Trail Making Test. Psychological Assessment, 28(2), 171-180. https://doi.org/10.1037/pas0000177
}
