% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gifti_writer.R
\name{gifti_xml_write}
\alias{gifti_xml_write}
\title{Write XML tree to a gifti file.}
\usage{
gifti_xml_write(filepath, xmltree, options = c("as_xml", "format"))
}
\arguments{
\item{filepath}{path to the output gifti file}

\item{xmltree}{XML tree from xml2}

\item{options}{output options passed to \code{\link[xml2]{write_xml}}.}
}
\description{
Write XML tree to a gifti file.
}
\examples{
  outfile = tempfile(fileext = '.gii');
  my_data_sets = list(rep(3.1, 3L), matrix(seq(6)+0.1, nrow=2L));
  xmltree = gifti_xml(my_data_sets, datatype='NIFTI_TYPE_FLOAT32');
  # Here we add global metadata:
  xmltree = gifti_xml_add_global_metadata(xmltree, list("User"="Me", "Day"="Monday"));
  # Validating your XML never hurts
  gifti_xsd = "https://www.nitrc.org/frs/download.php/158/gifti.xsd";
  xml2::xml_validate(xmltree, xml2::read_xml(gifti_xsd));
  gifti_xml_write(outfile, xmltree);  # Write your custom tree to a file.

}
\references{
\url{https://www.nitrc.org/frs/download.php/2871/GIFTI_Surface_Format.pdf}
}
