% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mghheader.R
\name{ras.to.surfaceras}
\alias{ras.to.surfaceras}
\title{Translate RAS coordinates, as used in volumes by applying vox2ras, to surface RAS.}
\usage{
ras.to.surfaceras(header_cras, ras_coords, first_voxel_RAS = c(1, 1, 1))
}
\arguments{
\item{header_cras}{an MGH header instance from which to extract the cras (center RAS), or the cras vector, i.e., a numerical vector of length 3}

\item{ras_coords}{nx3 numerical vector, the input surface RAS coordinates. Could be the vertex coordinates of an 'fs.surface' instance, or the RAS coords from a surface label.}

\item{first_voxel_RAS}{the RAS of the first voxel, see \code{\link{mghheader.centervoxelRAS.from.firstvoxelRAS}} for details. Ignored if 'header_cras' is a vector.}
}
\value{
the surface RAS coords for the input RAS coords
}
\description{
Translate RAS coordinates, as used in volumes by applying vox2ras, to surface RAS.
}
\note{
The RAS can be computed from Surface RAS by adding the center RAS coordinates, i.e., it is nothing but a translation.
}
