% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/invfourier.R
\name{invfourier}
\alias{invfourier}
\title{Inverse Fourier transform for operators}
\usage{
invfourier(R, lags = 0:0)
}
\arguments{
\item{R}{the operator to invert}

\item{lags}{lags to compute}
}
\value{
Time domain operator serie object
}
\description{
Inverse Fourier transform of a given Frequency Domain Operator.
}
\examples{
n = 100
X = rar(n)
Y = rar(n)
#estimate regressors in model $Y_t = \\sum_{i\\in Z} A_i X_{t-i}$
SYX = spectral.density(Y, X)
SXX = spectral.density(X)
R = freqdom.ratio(SYX,SXX, n)
A = invfourier(R)
}
\seealso{
\code{\link{fourier.transform}}
}

