% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bs4dash.R
\name{bs4dash_color}
\alias{bs4dash_color}
\title{bs4Dash main colors}
\usage{
bs4dash_color(
  blue = NULL,
  lightblue = NULL,
  navy = NULL,
  cyan = NULL,
  teal = NULL,
  olive = NULL,
  green = NULL,
  lime = NULL,
  orange = NULL,
  yellow = NULL,
  fuchsia = NULL,
  purple = NULL,
  maroon = NULL,
  red = NULL,
  black = NULL,
  gray_x_light = NULL,
  gray_600 = NULL,
  gray_800 = NULL,
  gray_900 = NULL,
  white = NULL
)
}
\arguments{
\item{blue}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#007bff")}. This color is used for \strong{primary} status.}

\item{lightblue}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#3c8dbc")}.}

\item{navy}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#001f3f")}.}

\item{cyan}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#17a2b8")}. This color is used for \strong{info} status.}

\item{teal}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#39cccc")}.}

\item{olive}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#3d9970")}.}

\item{green}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#28a745")}. This color is used for \strong{success} status.}

\item{lime}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#01ff70")}.}

\item{orange}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#ff851b")}.}

\item{yellow}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#ffc107")}. This color is used for \strong{warning} status.}

\item{fuchsia}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#f012be")}.}

\item{purple}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#605ca8")}.}

\item{maroon}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#d81b60")}.}

\item{red}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#dc3545")}. This color is used for \strong{danger} status.}

\item{black}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#111")}.}

\item{gray_x_light}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#d2d6de")}.}

\item{gray_600}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#6c757d")}. This color is used for \strong{secondary} status.}

\item{gray_800}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#343a40")}. Color for dark skin.}

\item{gray_900}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#212529")}. Color for text in body.}

\item{white}{Default: \Sexpr[results=rd, stage=install]{fresh:::rd_col("#ffffff")}.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
bs4Dash main colors
}
\examples{

# Change colors used in bs4Dash
bs4dash_color(
  blue = "#F7FE2E",
  lightblue = "#01DF3A"
)

if (interactive()) {

  library(shiny)
  library(bs4Dash)

  ui <- bs4DashPage(
    title = "bs4Dash Custom Colors",
    # sidebar_collapsed = FALSE,
    navbar = bs4DashNavbar(),
    sidebar = bs4DashSidebar(
      title = "bs4Dash Custom Colors",
      skin = "light",
      bs4SidebarMenu(
        bs4SidebarMenuItem(
          tabName = "tab1",
          text = "UI components"
        )
      )
    ),
    body = bs4DashBody(

      use_theme(create_theme(
        bs4dash_color(
          blue = "#F7FE2E",
          navy = "#01DF3A"
        )
      )),

      bs4TabItems(
        bs4TabItem(
          tabName = "tab1",
          tags$h2("UI components", class = "bg-navy"),
          tags$h4("bs4ValueBox"),
          fluidRow(
            bs4ValueBox(
              value = 150,
              subtitle = "ValueBox with primary status",
              status = "primary",
              icon = "shopping-cart",
              href = "#",
              width = 4
            )
          ),
          tags$h4("bs4Card"),
          fluidRow(
            bs4Card(
              title = "Card with primary status",
              closable = FALSE,
              width = 6,
              solidHeader = TRUE,
              status = "primary",
              collapsible = TRUE,
              p("Box Content")
            )
          )
        )
      )
    )
  )

  server <- function(input, output) {

  }

  shinyApp(ui, server)

}
}
