% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_schema.R
\name{create_schema}
\alias{create_schema}
\title{Create a Table Schema for a data frame}
\usage{
create_schema(data)
}
\arguments{
\item{data}{A data frame.}
}
\value{
List describing a Table Schema.
}
\description{
Creates a \href{https://specs.frictionlessdata.io/table-schema/}{Table Schema} for
a data frame, listing all column names and types as field names and
(converted) types.
}
\section{Table schema properties}{

The Table Schema will be created from the data frame columns:
\itemize{
\item \code{name}: contains the column name.
\item \code{title}: not set.
\item \code{description}: not set.
\item \code{type}: contains the converted column type (see further).
\item \code{format}: not set and can thus be considered \code{default}.
This is also the case for dates, times and datetimes, since
\code{\link[readr:write_delim]{readr::write_csv()}} used by \code{\link[=write_package]{write_package()}} will format those to ISO8601
which is considered the default.
Datetimes in local or non-UTC timezones will be converted to UTC before
writing.
\item \code{constraints}: not set, except for factors (see further).
\item \code{missingValues}: not set.
\code{\link[=write_package]{write_package()}} will use the default \code{""} for missing values.
\item \code{primaryKey}: not set.
\item \code{foreignKeys}: not set.
}
\subsection{Field types}{

The column type will determine the field \code{type}, as follows:
\itemize{
\item \code{character} as
\href{https://specs.frictionlessdata.io/table-schema/#string}{string}.
\item \code{Date} as \href{https://specs.frictionlessdata.io/table-schema/#date}{date}.
\item \code{difftime} as
\href{https://specs.frictionlessdata.io/table-schema/#number}{number}.
\item \code{factor} as
\href{https://specs.frictionlessdata.io/table-schema/#string}{string} with
factor levels as \code{enum}.
\item \code{\link[hms:hms]{hms::hms()}} as
\href{https://specs.frictionlessdata.io/table-schema/#time}{time}.
\item \code{integer} as
\href{https://specs.frictionlessdata.io/table-schema/#integer}{integer}.
\item \code{logical} as.
\href{https://specs.frictionlessdata.io/table-schema/#boolean}{boolean}.
\item \code{numeric} as
\href{https://specs.frictionlessdata.io/table-schema/#number}{number}.
\item \code{POSIXct}/\code{POSIXlt} as
\href{https://specs.frictionlessdata.io/table-schema/#datetime}{datetime}.
\item Any other type as
\href{https://specs.frictionlessdata.io/table-schema/#any}{any}.
}
}
}

\examples{
# Create a data frame
df <- data.frame(
  id = c(as.integer(1), as.integer(2)),
  timestamp = c(
    as.POSIXct("2020-03-01 12:00:00", tz = "EET"),
    as.POSIXct("2020-03-01 18:45:00", tz = "EET")
  ),
  life_stage = factor(c("adult", "adult"), levels = c("adult", "juvenile"))
)

# Create a Table Schema from the data frame
schema <- create_schema(df)
str(schema)
}
\seealso{
Other create functions: 
\code{\link{create_package}()}
}
\concept{create functions}
