% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_trailing_whitespace.R
\name{delete_trailing_whitespace}
\alias{delete_trailing_whitespace}
\title{Remove Trailing Whitespace From Files}
\usage{
delete_trailing_whitespace(...)
}
\arguments{
\item{...}{Arguments passed to \code{\link{find_files}}.}
}
\value{
\code{\link[base:invisible]{Invisibly}}
\code{\link[base:NULL]{NULL}}.
}
\description{
Trailing whitespace is a classical lint.
}
\examples{
dir <- tempfile()
dir.create(dir)
file.copy(system.file("runit_tests", package = "fritools"), dir,
          recursive = TRUE)
delete_trailing_whitespace(path = dir, recursive = TRUE)
unlink(dir, recursive = TRUE)
}
\seealso{
Other file utilities: 
\code{\link{clipboard_path}()},
\code{\link{delete_trailing_blank_lines}()},
\code{\link{develop_test}()},
\code{\link{file_copy}()},
\code{\link{file_modified_last}()},
\code{\link{file_save}()},
\code{\link{find_files}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{search_files}()},
\code{\link{split_code_file}()},
\code{\link{touch}()}
}
\concept{file utilities}
