% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ft_links.R
\name{ft_links}
\alias{ft_links}
\alias{ft_links.character}
\alias{ft_links.ft}
\alias{ft_links.ft_ind}
\title{Get full text links}
\usage{
ft_links(x, from = NULL, plosopts = list(), crossrefopts = list(),
  entrezopts = list(), bmcopts = list(), ...)

\method{ft_links}{ft}(x, from = NULL, plosopts = list(),
  crossrefopts = list(), entrezopts = list(), bmcopts = list(), ...)

\method{ft_links}{ft_ind}(x, from = NULL, plosopts = list(),
  crossrefopts = list(), entrezopts = list(), bmcopts = list(), ...)

\method{ft_links}{character}(x, from = NULL, plosopts = list(),
  crossrefopts = list(), entrezopts = list(), bmcopts = list(), ...)
}
\arguments{
\item{x}{One of \code{ft}, \code{ft_ind}, or a character string of DOIs.}

\item{from}{Source to query. Ignored when \code{ft_ind} class passed.}

\item{plosopts}{PLOS options. See \code{?searchplos}}

\item{crossrefopts}{Crossref options. See \code{?cr_works}}

\item{entrezopts}{Entrez options. See \code{?entrez_search}}

\item{bmcopts}{BMC options. See \code{?bmc_search}}

\item{...}{Further args passed on to \code{\link[httr]{GET}}. Not working right now...}
}
\value{
An object of class ft_links, with either a list or data.frame for each
DOI, with links for XML and PDF links (typically).
}
\description{
Get full text links
}
\details{
Inputs can be an object of class \code{ft}, \code{ft_ind}, or a
character string of DOIs. You can specify a specific source for four sources
(PLOS, BMC, Crossref, and Entrez), but any other publishers we guess the
publisher form the input DOI(s), then attempt to generate full text links
based on the publisher (if found). Of course, guessing the publisher makes
things slower as it requires an HTTP request.

Strategy varies by publisher. For some we can construct XML and PDF links
only from the DOI. For others, we need to make an HTTP request to the
publisher to get additional information - this of course makes things slower.
}
\examples{
\dontrun{
# Entrez
(res1 <- ft_search(query='ecology', from='entrez'))
res1$entrez$data$doi
## directly from ft_search output
(out <- ft_links(res1))
out$entrez
out$entrez$data[[1]]
## directly individual elements of ft_search output
(out <- ft_links(res1$entrez))
out$entrez
## from character vector of DOIs
x <- c("10.1371/journal.pone.0086169", "10.1016/j.ympev.2010.07.013")
(out2 <- ft_links(x, from = "entrez"))
out2$entrez

# Crossref
(res2 <- ft_search(query='ecology', from='crossref'))
res2$crossref$data$doi
## directly from ft_search output
(out <- ft_links(res2))
out$crossref
out$crossref$data[[1]]
## directly individual elements of ft_search output
(out <- ft_links(res2$crossref))
out$crossref
## from character vector of DOIs
x <- c("10.1016/s1754-5048(14)00139-1", "10.1016/b978-0-12-378260-1.50017-8")
(out2 <- ft_links(x, from = "crossref"))
out2$crossref

# PLOS
(res3 <- ft_search(query='ecology', from='plos', plosopts=list(
   fl=c('id','author','eissn','journal','counter_total_all','alm_twitterCount'))))
res3$plos$data$id
## directly from ft_search output
(out <- ft_links(res3))
out$plos
out$plos$data[[1]]
## directly individual elements of ft_search output
(out <- ft_links(res3$plos))
out$plos
## from character vector of DOIs
x <- c("10.1371/journal.pone.0017342", "10.1371/journal.pone.0091497")
out3 <- ft_links(x, from = "plos")
out3$plos

# BMC
(res <- ft_search(query='ecology', from='bmc'))
res$bmc
## directly from ft_search output
(out <- ft_links(res))
out$bmc
out$bmc$data[[1]]
## directly individual elements of ft_search output
(out <- ft_links(res$bmc))
out$bmc

# Character input
out4 <- ft_links('10.1371/journal.pone.0086169')
out4$plos

# other publishers
## elife
res <- ft_links(c('10.7554/eLife.03032', '10.7554/eLife.02747'))
res$elife

## peerj
ft_links('10.7717/peerj.228')
ft_links(c('10.7717/peerj.228', '10.7717/peerj.1200'))

## frontiersin
(res <- ft_links('10.3389/fphar.2014.00109'))
res$frontiersin

## copernicus
(res <- ft_links('10.5194/angeo-31-2157-2013'))
res$copernicus

## cogent
(res <- ft_links('10.1080/23311916.2014.938430'))
res$cogent

## bmc
(res <- ft_links('10.1186/2049-2618-2-7'))
res$bmc
(res <- ft_links('10.1186/2049-2618-2-7', from = "bmc"))

## Many publishers, elife and peerj
res <- ft_links(c('10.7554/eLife.03032', '10.7717/peerj.228'))
res$elife
res$peerj
}
}

