% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_profiling.R
\name{plotar}
\alias{plotar}
\title{Correlation plots}
\usage{
plotar(data, str_input, str_target, plot_type, path_out)
}
\arguments{
\item{data}{data frame source}

\item{str_input}{string input variable (if empty, it runs for all numeric variable), it can take a single character value or a character vector.}

\item{str_target}{string of the variable to predict, it supports binary or multinominal values.}

\item{plot_type}{Indicates the type of plot to retrieve, available values: "boxplot" or "histdens".}

\item{path_out}{path directory, if it has a value the plot is saved}
}
\value{
Single or multiple plots specified by 'plot_type' parameter
}
\description{
Visual correlation analysis. Plot different graphs in order to expose the inner information of any numeric variable against the target variable
}
\examples{
\dontrun{
## Run for all numeric variables
plotar(data=heart_disease, str_target="has_heart_disease",
	plot_type="histdens")
plotar(heart_disease, str_input = 'age', str_target = 'chest_pain', plot_type = "boxplot")
}
}

