% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simul_traj}
\alias{simul_traj}
\title{Single trajectory simulation}
\usage{
simul_traj(n_point, distrib = "normal", max_iter = 10000)
}
\arguments{
\item{n_point}{integer value, number of points in the trajectory.}

\item{distrib}{character string, type of probability distribution used to
simulate the data among \code{"normal"}, \code{"cauchy"}, \code{"dexp"}, \code{"student"}.}

\item{max_iter}{integer, maximum number of iteration for the iterative
simulation process.}
}
\value{
Vector of size \code{n_point} with the trajectory values.
}
\description{
Simulate a trajectory of length \code{n_point} using a random generator
associated to different probability distribution.
}
\examples{
simu_vec <- simul_traj(100)
plot(simu_vec, xlab = "point", ylab = "value")
}
\references{
Zaineb Smida, Lionel Cucala, Ali Gannoun & Ghislain Durif (2022)
A median test for functional data, Journal of Nonparametric Statistics,
34:2, 520-553,
\doi{10.1080/10485252.2022.2064997},
\href{https://hal.science/hal-03658578}{hal-03658578}
}
\seealso{
\code{\link[=simul_data]{simul_data()}}
}
