% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_fof_pc.R
\name{predict_fof_pc}
\alias{predict_fof_pc}
\title{Use a function-on-function linear regression model for prediction}
\usage{
predict_fof_pc(object, mfdobj_y_new, mfdobj_x_new)
}
\arguments{
\item{object}{A list obtained as output from \code{fof_pc},
i.e. a fitted function-on-function linear regression model.}

\item{mfdobj_y_new}{An object of class \code{mfd} containing
new observations of the functional response.}

\item{mfdobj_x_new}{An object of class \code{mfd} containing
new observations of the functional covariates.}
}
\value{
A list of mfd objects. It contains:
\itemize{
\item \code{pred_error}: the prediction error of the
standardized functional response variable,
\item \code{pred_error_original_scale}:
the prediction error of the functional
response variable on the original scale,
\item \code{y_hat_new}: the prediction of the
functional response observations on the original scale,
\item \code{y_z_new}: the standardized version of the
functional response observations provided in \code{mfdobj_y_new},
\item \code{y_hat_z_new}: the prediction of the
functional response observations on the standardized/studentized scale.
}
}
\description{
Predict new observations of the functional response variable
and calculate the corresponding prediction error
(and their standardized or studentized version)
given new observations of functional covariates and
a fitted function-on-function linear regression model.
}
\examples{
library(funcharts)
data("air")
air <- lapply(air, function(x) x[1:10, , drop = FALSE])
fun_covariates <- c("CO", "temperature")
mfdobj_x <- get_mfd_list(air[fun_covariates], lambda = 1e-2)
mfdobj_y <- get_mfd_list(air["NO2"], lambda = 1e-2)
mod <- fof_pc(mfdobj_y, mfdobj_x)
predict_fof_pc(mod,
               mfdobj_y_new = mfdobj_y,
               mfdobj_x_new = mfdobj_x)

}
\references{
Centofanti F, Lepore A, Menafoglio A, Palumbo B, Vantini S. (2021)
Functional Regression Control Chart.
\emph{Technometrics}, 63(3):281--294. \url{doi:10.1080/00401706.2020.1753581}
}
\author{
C. Capezza, F. Centofanti
}
