% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrating.R
\name{calibrate_gmean_bymot}
\alias{calibrate_gmean_bymot}
\title{Modelling of performances
 by assembly motif}
\usage{
calibrate_gmean_bymot(fobs, assMotif)
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{assMotif}{a vector of labels of \code{length(fobs)}.
The vector \code{assMotif} contains the assembly motifs of assemblages.}
}
\value{
Return a vector of \code{length(fobs)}.
Its values are computed as the geometric mean of performances
of assemblages that share a same assembly motif.
}
\description{
Take a vector \code{fobs} of assembly performances
and return a vector of performances
predicted as the geometric mean
of performances of all assemblages
that share the same assembly motif. \cr

Assembly motifs are labelled in the vector \code{assMotif}.
}
\details{
Modelled performances are computed
using arithmetic mean (\code{opt.mean = "amean"})
of performances of assemblages
that share a same assembly motif (\code{opt.model = "bymot"})
by including all assemblages that belong to a same assembly motif.
}
\seealso{
\code{\link{calibrate_amean_bymot}} arithmetic mean
  by assembly motif. \cr
\code{\link{calibrate_amean_byelt}} arithmetic mean
  by elements occurring within assembly motif. \cr
\code{\link{calibrate_gmean_bymot}} geometric mean
  by assembly motif. \cr
\code{\link{calibrate_gmean_byelt}} geometric mean
  by elements occurring within assembly motif. \cr
}
\keyword{internal}
