% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_raoq.R
\name{fd_raoq}
\alias{fd_raoq}
\title{Compute Rao's entropy index (Rao's Q)}
\usage{
fd_raoq(traits = NULL, sp_com, dist_matrix = NULL)
}
\arguments{
\item{traits}{The matrix dataset for which you want to compute the index}

\item{sp_com}{Site-species matrix with sites as rows and species as columns
if not provided, the function considers all species with equal
abundance in a single site. This can be either a \code{matrix},
a \code{data.frame}, or a \code{\link[Matrix:Matrix]{Matrix::Matrix()}} object.
package.}

\item{dist_matrix}{A dissimilarity matrix that can be provided instead of a
trait data.frame (default: \code{NULL}).
This can be either a \code{matrix}, a \code{data.frame},
or a \code{\link[Matrix:Matrix]{Matrix::Matrix()}} object.}
}
\value{
a data.frame with two columns:
\itemize{
\item \code{site} the names of the sites as the row names of the input \code{sp_com},
\item \code{Q} the values of Rao's quadratic entropy at each site.
}
}
\description{
Compute Rao's entropy index (Rao's Q)
}
\examples{
data(traits_birds)
fd_raoq(traits_birds)

}
\references{
Pavoine S., Dolédec S. (2005). The apportionment of quadratic entropy: a
useful alternative for partitioning diversity in ecological data.
Environmental and Ecological Statistics, 12(2), 125–138.
\doi{10.1007/s10651-005-1037-2}
}
