% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_funnel.R
\name{funnel_start}
\alias{funnel_start}
\title{Start a funnel}
\usage{
funnel_start(tbl, moment_type, moment, tstamp, user)
}
\arguments{
\item{tbl}{A table of different moments and timestamps}

\item{moment_type}{The first moment in the funnel}

\item{moment}{The name of the column with the moment_type}

\item{tstamp}{The name of the column with the timestamps of the moments}

\item{user}{The name of the column indicating the user who did the moment}
}
\description{
Start a funnel
}
\examples{
library(dplyr)

activity <- tibble::tribble(
  ~ "user_id", ~ "event", ~ "timestamp",
  1, "landing", "2019-07-01",
  1, "registration", "2019-07-02",
  1, "purchase", "2019-07-07",
  1, "purchase", "2019-07-10",
  2, "landing", "2019-08-01",
  2, "registration", "2019-08-15",
  3, "landing", "2019-05-01",
  3, "registration", "2019-06-01",
  3, "purchase", "2019-06-04",
  4, "landing", "2019-06-13")

activity \%>\%
  funnel_start(moment_type = "landing",
               moment = "event",
               tstamp = "timestamp",
               user = "user_id")

}
