# WARNING - Generated by {fusen} from dev/flat_inflate_all.Rmd: do not edit by hand

#' Inflate all your flat files
#'
#' Inflate all the flat files stored in "dev/" and starting with "flat_"
#'
#' @param pkg Path to package
#' @param clean Logical. Whether to help detect unregistered files.
#' @inheritParams inflate
#'
#' @importFrom yaml read_yaml
#' @importFrom cli cat_rule
#' @importFrom devtools check
#'
#' @return side effect. Inflates all your flat files that can be inflated.
#'
#' @details This requires to [inflate()] all flat files individually at least once, so that their specific inflate configurations are stored.
#'
#' This also requires to register all R, tests and vignettes files of your package, even if not created with an inflate. Run [inflate_all()] once and read the messages. The first time, you will probably need to run [register_all_to_config()] if your package is not new.
#'
#' For more information, read the `vignette("inflate-all-your-flat-files", package = "fusen")`
#'
#' @seealso
#'   [inflate()] for the options of a single file inflate,
#'   [check_not_registered_files()] for the list of files not already associated with a flat file in the config file,
#'   [register_all_to_config()] for automatically registering all files already present in the project before the first `inflate_all()`
#'
#' @export
#' @examples
#' \dontrun{
#' # Usually, in the current package run inflate_all() directly
#' # These functions change the current user workspace
#' inflate_all()
#' # Or inflate_all_no_check() to prevent checks to run
#' inflate_all_no_check()
#' }
#'
#' # You can also inflate_all flats of another package as follows
#' # Example with a dummy package with a flat file
#' dummypackage <- tempfile("inflateall")
#' dir.create(dummypackage)
#' fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
#' flat_files <- add_minimal_package(
#'   pkg = dummypackage,
#'   overwrite = TRUE,
#'   open = FALSE
#' )
#' flat_file <- flat_files[grep("flat", basename(flat_files))]
#' # Inflate the flat file once
#' usethis::with_project(dummypackage, {
#'   # if you are starting from a brand new package, inflate_all() will crash
#'   # it's because of the absence of a fusen config file
#'   #
#'   # inflate_all() # will crash
#'
#'   # Add licence
#'   usethis::use_mit_license("John Doe")
#'
#'   # you need to inflate manually your flat file first
#'   inflate(
#'     pkg = dummypackage,
#'     flat_file = flat_file,
#'     vignette_name = "Get started",
#'     check = FALSE,
#'     open_vignette = FALSE,
#'     document = TRUE,
#'     overwrite = "yes"
#'   )
#'
#'   # your config file has been created
#'   config_yml_ref <-
#'     yaml::read_yaml(getOption("fusen.config_file", default = "dev/config_fusen.yaml"))
#' })
#'
#' # Next time, you can run inflate_all() directly
#' usethis::with_project(dummypackage, {
#'   # now you can run inflate_all()
#'   inflate_all(check = FALSE, document = TRUE)
#' })
#'
#' # Clean the temporary directory
#' unlink(dummypackage, recursive = TRUE)
inflate_all <- function(pkg = ".", document = TRUE, check = TRUE, open_vignette = FALSE, overwrite = TRUE, clean = TRUE, ...) {
  config_file <- getOption("fusen.config_file", default = "dev/config_fusen.yaml")

  if (!file.exists(config_file)) {
    config_yml <- list()
    stop_after_infos <- TRUE
  } else {
    config_yml <- read_yaml(config_file)
    stop_after_infos <- FALSE
  }

  diag <- pre_inflate_all_diagnosis(config_yml = config_yml, pkg = pkg)
  # Run stop first only
  pre_inflate_all_diagnosis_eval(diag, type_stop = TRUE)
  # If message or warnings about flat files, show at the end of the process
  # => Is going to be
  pre_inflate_all_diagnosis_eval(diag, type_stop = FALSE)

  if (stop_after_infos) {
    cli::cli_abort(
      c(
        " {.fn fusen::inflate_all} requires a configuration file to work properly.",
        " There is no configuration file at this place in your package: '{config_file}'",
        "\nYour active flat files must be individually inflated at least once manually before you can use {.fn inflate_all}.",
        " This will create a proper configuration file with a section for each flat file.",
        "\nThis error is common if you were using {.pkg fusen} prior to v0.5.1.",
        "Read `vignette('{.vignette [inflate-all-your-flat-files](fusen::inflate-all-your-flat-files)}', package = 'fusen')` for more information."
      )
    )
    return(NULL)
  }
  inflate_params <- read_inflate_params(config_yml = config_yml)

  if (length(inflate_params) == 0) {
    message("No flat files were inflated")
  } else {
    apply_inflate <- function(inflate_params, pkg, overwrite, open_vignette) {
      config_file <- getOption("fusen.config_file", default = "dev/config_fusen.yaml")
      # Change config option temporary, to be able to modify it on the fly
      config_file_tmp <- tempfile(pattern = "tempconfig")
      on.exit(file.remove(config_file_tmp))
      file.copy(config_file, to = config_file_tmp)
      options("fusen.config_file" = config_file_tmp)
      on.exit(options("fusen.config_file" = config_file))

      invisible(
        lapply(inflate_params, function(flat_file) {
          flat_file$pkg <- pkg
          flat_file$overwrite <- overwrite
          flat_file$open_vignette <- open_vignette
          flat_file$document <- FALSE
          flat_file$check <- FALSE
          suppressMessages(do.call(inflate, flat_file))
        })
      )
    }

    apply_inflate(inflate_params, pkg = pkg, overwrite = overwrite, open_vignette = open_vignette)

    # Document and check package
    document_and_check_pkg(
      pkg = pkg,
      check = check,
      document = document,
      ...
    )
  }

  if (isTRUE(clean)) {
    cli::cat_rule("check not registered files")
    invisible(check_not_registered_files(path = pkg))
  }
  invisible(pkg)
}

#' @rdname inflate_all
#' @export
inflate_all_no_check <- function(pkg = ".", document = TRUE, open_vignette = FALSE, overwrite = TRUE, clean = TRUE, ...) {
  inflate_all(pkg = pkg, document = document, check = FALSE, open_vignette = open_vignette, overwrite = overwrite, clean = clean, ...)
}
