% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inflate.R
\name{inflate}
\alias{inflate}
\title{Inflate Rmd to package}
\usage{
inflate(
  pkg = ".",
  flat_file,
  vignette_name = "Get started",
  open_vignette = TRUE,
  check = TRUE,
  document = TRUE,
  overwrite = "ask",
  ...
)
}
\arguments{
\item{pkg}{Path to package}

\item{flat_file}{Path to Rmarkdown file to inflate}

\item{vignette_name}{Character. Title of the resulting vignette.
Use \code{NA} if you do not want to create a vignette.}

\item{open_vignette}{Logical. Whether to open vignette file at the end of the process}

\item{check}{Logical. Whether to check package after Rmd inflating}

\item{document}{Logical. Whether to document your package using \code{\link[attachment:att_amend_desc]{att_amend_desc}}}

\item{overwrite}{Logical (TRUE, FALSE) or character ("ask", "yes", "no).
Whether to overwrite vignette and functions if already exists.}

\item{...}{Arguments passed to \code{devtools::check()}.
For example, you can do \code{inflate(check = TRUE, quiet = TRUE)}, where \code{quiet} is
passed to \code{devtools::check()}.}
}
\value{
Package structure. Return path to current package.
}
\description{
Inflate Rmd to package
}
\examples{
# Create a new project
dummypackage <- tempfile("dummypackage")
dir.create(dummypackage)

# {fusen} steps
dev_file <- add_flat_template(template = "full", pkg = dummypackage, overwrite = TRUE)
flat_file <- dev_file[grepl("flat", dev_file)]
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
inflate(
  pkg = dummypackage, flat_file = flat_file,
  vignette_name = "Exploration of my Data", check = FALSE
)

# Explore directory of the package
# browseURL(dummypackage)

# Try pkgdown build
# usethis::use_pkgdown()
# pkgdown::build_site(dummypackage)
# Delete dummy package
unlink(dummypackage, recursive = TRUE)
}
\seealso{
\code{\link[=inflate_all]{inflate_all()}} to inflate every flat files according to the configuration file.
}
