% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionBackground.R
\name{fusionBackground}
\alias{fusionBackground}
\title{Adding FusionCharts borders & background}
\usage{
fusionBackground(
  fusionPlot,
  showBorder = FALSE,
  borderColor = "#666666",
  borderThickness = "4",
  borderAlpha = "80",
  bgColorStart = "#ffffff",
  bgColorEnd = NULL,
  bgAlphaStart = "50",
  bgAlphaEnd = NULL,
  bgratioStart = "60",
  bgratioEnd = "40",
  bgAngle = "180"
)
}
\arguments{
\item{fusionPlot}{fusionPlot object got by \code{fusionPlot()}}

\item{showBorder}{Show the chart border}

\item{borderColor}{Specify the color of the border}

\item{borderThickness}{Set the thickness of the border}

\item{borderAlpha}{Set the transparency of the border}

\item{bgColorStart, bgColorEnd}{Set the hex codes of the starting and ending gradient colors}

\item{bgAlphaStart, bgAlphaEnd}{Set the transparency of the starting ending gradient colors}

\item{bgratioStart, bgratioEnd}{Set the radius of gradient colors}

\item{bgAngle}{Set the angle in degrees of gradient colors}
}
\description{
\url{https://www.fusioncharts.com/dev/chart-guide/chart-configurations/border-and-background}
}
\examples{
library(fusionchartsR)
df <- data.frame(label = c("Venezuela", "Saudi", "Canada", "Russia"), value = c(290, 260, 180, 115))
df \%>\%
  fusionPlot(x = "label", y = "value", type = "column3d") \%>\%
  fusionBackground(showBorder = TRUE, bgColorStart = "#DDDDDD") \%>\%
  fusionTheme(theme = "fusion")

}
