% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/futility.R
\name{plotRCDF.byArm}
\alias{plotRCDF.byArm}
\title{Plot Characteristics of the Estimated Distribution of the Treatment Arm-Specific Number of Endpoints}
\usage{
plotRCDF.byArm(arm, eventTimeFrame = NULL, eventPPcohort = FALSE,
  eventPriorRate, eventPriorWeight, xlim = NULL, xlab = NULL, ylab = NULL,
  fileDir)
}
\arguments{
\item{arm}{a character string matching a treatment label in the \code{arm} variable in \code{interimData} that indicates the treatment arm for which the plot will be generated}

\item{eventTimeFrame}{a time frame within which endpoints are counted, specified in weeks as \code{c(start, end)}. If \code{NULL} (default), then all endpoints are counted.}

\item{eventPPcohort}{a logical value. If \code{TRUE}, only endpoints in the per-protocol cohort are counted. The default value is \code{FALSE}.}

\item{eventPriorRate}{a numeric vector of treatment arm-specific prior mean incidence rates for the endpoint, expressed as numbers of events per person-year at risk, with the arms in the same order as in the equally named input argument in the \code{\link{completeTrial.byArm}} function}

\item{eventPriorWeight}{a numeric vector in which each value represents a weight (i.e., a separate scenario) assigned to the prior gamma distribution of the treatment arm-specific event rate at the time when 50\% of the estimated person-time at risk in the given \code{arm} has been accumulated}

\item{xlim}{a numeric vector of the form \code{c(xmin, xmax)} for the user-specified x-axis limits. If \code{NULL} (default), then the computed range of x-axis values will be used.}

\item{xlab}{a character string for the user-specified x-axis label. If \code{NULL} (default), then the label "Number of Infections in Group \code{arm} (n)" will be used.}

\item{ylab}{a character string for the user-specified y-axis label. If \code{NULL} (default), then the label "P(Number of Infections in Group \code{arm} >= n ) x 100" will be used.}

\item{fileDir}{a character string specifying a path for the input directory}
}
\value{
None. The function is called solely for plot generation.
}
\description{
Takes the output from the \code{\link{completeTrial.byArm}} function and generates a plot describing characteristics of the estimated distribution of the treatment arm-specific number of endpoints.
}
\examples{
arm <- rep(c("C3","T1","T2"), each=250)
schedule <- rbinom(length(arm), 1, 0.01)
entry <- rpois(length(arm), lambda=60)
entry <- entry - min(entry)
last_visit_dt <- entry + runif(length(arm), min=0, max=80)
event <- rbinom(length(arm), 1, 0.01)
dropout <- rbinom(length(arm), 1, 0.02)
dropout[event==1] <- 0
exit <- rep(NA, length(arm))
exit[event==1] <- last_visit_dt[event==1] + 5
exit[dropout==1] <- last_visit_dt[dropout==1] + 5
followup <- ifelse(event==1 | dropout==1, 0, 1)
interimData <- data.frame(arm=arm, schedule2=schedule, entry=entry, exit=exit,
last_visit_dt=last_visit_dt, event=event, dropout=dropout, complete=0, followup=followup)

weights <- c(0.2, 0.4, 0.6)
for (j in 1:length(weights)){
  completeTrial.byArm(interimData=interimData, nTrials=50,
  trtNames=c("C3","T1","T2"),N=c(500,500,500),
  enrollRatePeriod=24, eventPriorWeight=weights[j], eventPriorRate=c(0.06,0.03,0.03),
  fuTime=80, visitSchedule=seq(0, 80, by=4), visitSchedule2=c(0,seq(from=8,to=80,by=12)),
  saveDir="./", randomSeed=9)
}

pdf(file=paste0("./","rcdf_byArm_arm=T1_",
"eventPriorRateC3=0.06_eventPriorRateT1=0.03_eventPriorRateT2=0.03.pdf"), width=6,
height=5)
plotRCDF.byArm(arm="T1", eventPriorRate=c(0.06,0.03,0.03), eventPriorWeight=weights,
fileDir="./")
dev.off()

}
\seealso{
\code{\link{completeTrial.byArm}} and \code{\link{plotRCDF.pooledArms}}
}
