% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchjobs_template.R
\name{batchjobs_template}
\alias{batchjobs_lsf}
\alias{batchjobs_openlava}
\alias{batchjobs_sge}
\alias{batchjobs_slurm}
\alias{batchjobs_template}
\alias{batchjobs_torque}
\title{BatchJobs LSF, OpenLava, SGE, Slurm and Torque futures}
\usage{
batchjobs_lsf(expr, envir = parent.frame(), substitute = TRUE,
  globals = TRUE, label = "BatchJobs", pathname = NULL,
  resources = list(), job.delay = FALSE, ...)

batchjobs_openlava(expr, envir = parent.frame(), substitute = TRUE,
  globals = TRUE, label = "BatchJobs", pathname = NULL,
  resources = list(), job.delay = FALSE, ...)

batchjobs_sge(expr, envir = parent.frame(), substitute = TRUE,
  globals = TRUE, label = "BatchJobs", pathname = NULL,
  resources = list(), job.delay = FALSE, ...)

batchjobs_slurm(expr, envir = parent.frame(), substitute = TRUE,
  globals = TRUE, label = "BatchJobs", pathname = NULL,
  resources = list(), job.delay = FALSE, ...)

batchjobs_torque(expr, envir = parent.frame(), substitute = TRUE,
  globals = TRUE, label = "BatchJobs", pathname = NULL,
  resources = list(), job.delay = FALSE, ...)
}
\arguments{
\item{expr}{The R expression to be evaluated}

\item{envir}{The environment in which global environment
should be located.}

\item{substitute}{Controls whether \code{expr} should be
\code{substitute()}:d or not.}

\item{globals}{(optional) a logical, a character vector, a named list, or a \link[globals]{Globals} object.  If TRUE, globals are identified by code inspection based on \code{expr} and \code{tweak} searching from environment \code{envir}.  If FALSE, no globals are used.  If a character vector, then globals are identified by lookup based their names \code{globals} searching from environment \code{envir}.  If a named list or a Globals object, the globals are used as is.}

\item{label}{(optional) Label of the future (where applicable, becomes the job name for most job schedulers).}

\item{pathname}{A BatchJobs template file (\pkg{brew} formatted).}

\item{resources}{A named list passed to the BatchJobs template (available as variable \code{resources}).}

\item{job.delay}{(optional) Passed as is to \code{\link[BatchJobs]{submitJobs}()}.}

\item{\ldots}{Additional arguments passed to \code{\link{BatchJobsFuture}()}.}
}
\value{
An object of class \code{BatchJobsFuture}.
}
\description{
LSF, OpenLava, SGE, Slurm and Torque BatchJobs futures are
asynchronous multiprocess futures that will be evaluated on
a compute cluster via a job scheduler.
}
\details{
These type of BatchJobs futures rely on BatchJobs backends set
up using the following \pkg{BatchJobs} functions:
\itemize{
 \item \code{\link[BatchJobs]{makeClusterFunctionsLSF}()} for \href{https://en.wikipedia.org/wiki/Platform_LSF}{Load Sharing Facility (LSF)}
 \item \code{makeClusterFunctionsOpenLava()} for \href{https://en.wikipedia.org/wiki/OpenLava}{OpenLava} (only BatchJobs (>= 1.7.0))
 \item \code{\link[BatchJobs]{makeClusterFunctionsSGE}()} for \href{https://en.wikipedia.org/wiki/Oracle_Grid_Engine}{Sun/Oracle Grid Engine (SGE)}
 \item \code{\link[BatchJobs]{makeClusterFunctionsSLURM}()} for \href{https://en.wikipedia.org/wiki/Slurm_Workload_Manager}{Slurm}
 \item \code{\link[BatchJobs]{makeClusterFunctionsTorque}()} for \href{https://en.wikipedia.org/wiki/TORQUE}{TORQUE} / PBS
}
}

